<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>DashBoard</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
    <meta name="description" content="Login Area">
    <meta name="author" content="">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.0/jquery.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <?php include("app_css.php"); ?>
    
    <script language="javascript">
        function complainadd(recahrge_id) {
            document.getElementById("hidcomplain").value = "Set";
            document.getElementById("recid").value = recahrge_id;
            document.getElementById("frmcomplain").submit();
        }
    </script>
    <script>
        $(document).ready(function(){
            $('[data-toggle="tooltip"]').tooltip(); 
        });

        function statuschecking(value) {
            document.getElementById("divstatus"+value).style.display = "none";
            document.getElementById("divprocess"+value).style.display = "block";
            $.ajax({
                url:'<?php echo base_url()."rec_status/test?id=";?>'+value,
                type:'post',
                cache:false,
                success:function(html) {
                    if(html == "gtid is wrong.") {
                        document.getElementById("sts"+value).innerHTML = "Failure";
                    } else {
                        document.getElementById("sts"+value).innerHTML = html;
                    }
                    document.getElementById("divstatus"+value).style.display = "block";
                    document.getElementById("divprocess"+value).style.display = "none";
                }
            });
        }
        
        function disputechecking(value) {
            document.getElementById("divstatus"+value).style.display = "none";
            document.getElementById("divprocess"+value).style.display = "block";
            $.ajax({
                url:'<?php echo base_url()."dispute/test?id=";?>'+value,
                type:'post',
                cache:false,
                success:function(html) {
                    if(html == "gtid is wrong.") {
                        document.getElementById("dsp"+value).innerHTML = "Failure";
                    } else {
                        document.getElementById("dsp"+value).innerHTML = html;
                    }
                    document.getElementById("divstatus"+value).style.display = "block";
                    document.getElementById("divprocess"+value).style.display = "none";
                }
            });
        }
    </script>
    <style>
        /* Tools Section Container */
        .tools-container {
            background: #fce390;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            padding: 15px;
            margin-bottom: 30px;
            border: 1px solid #000000;
        }
        
        .tools-header {
            font-size: 18px;
            font-weight: 600;
            color: #000000;
            padding: 10px 15px;
            margin: -15px -15px 15px -15px;
            background: #fce390;
            border-bottom: 1px solid #000000;
            border-radius: 8px 8px 0 0;
        }
        
        /* Tool Icons Styles */
        .tool-icon {
            text-align: center;
            padding: 20px 10px;
            margin-bottom: 15px;
            border-radius: 8px;
            background: #fff;
            box-shadow: 0 3px 10px rgba(0,0,0,0.08);
            transition: all 0.3s ease;
            border: 1px solid #e0e0e0;
            border-bottom: 3px solid #3498db;
            cursor: pointer;
            height: 100%;
        }
        
        .tool-icon:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 15px rgba(0,0,0,0.1);
            border-bottom: 3px solid #000000;
            background: #e8ff75;
        }
        
        .tool-icon i {
            font-size: 32px;
            color: #3498db;
            margin-bottom: 10px;
        }
        
        .tool-icon h4 {
            font-size: 14px;
            font-weight: 600;
            margin: 0;
            color: #333;
        }
        
        .tool-link {
            text-decoration: none;
            display: block;
            color: inherit;
            height: 100%;
        }
        
        /* Different color variations for tool sections */
        .services-tools .tool-icon {
            border-bottom-color: #3498db;
        }
        .services-tools .tool-icon i {
            color: #3498db;
        }
        
        .reports-tools .tool-icon {
            border-bottom-color: #2ecc71;
        }
        .reports-tools .tool-icon i {
            color: #2ecc71;
        }
        
        .more-tools .tool-icon {
            border-bottom-color: #9b59b6;
        }
        .more-tools .tool-icon i {
            color: #9b59b6;
        }
    </style>
</head>

<body"> 
    <?php include("menu.php"); ?>
  
    <div class="container">
        <?php
        if($this->session->flashdata('message')){
            echo "<div class='alert alert-success fade in'>".$this->session->flashdata('message')."</div>";
        }	
        if($message != ''){
            echo "<div class='alert alert-success fade in'>".$message."</div>";
        }
        ?>
    </div>
    
    <div class="container">
        <!-- Quick Services Tools Section -->
        <div class="tools-container services-tools">
            <div class="tools-header">
                <i class="fas fa-tools"></i> Quick Services
            </div>
            <div class="row">
                <div class="col-xs-6 col-sm-4 col-md-2">
                    <a href="<?php echo base_url(); ?>recharge_zone" class="tool-link">
                        <div class="tool-icon">
                            <i class="fas fa-mobile-alt"></i>
                            <h4>Prepaid</h4>
                        </div>
                    </a>
                </div>
                <div class="col-xs-6 col-sm-4 col-md-2">
                    <a href="<?php echo base_url(); ?>dth" class="tool-link">
                        <div class="tool-icon">
                            <i class="fas fa-wifi"></i>
                            <h4>DTH</h4>
                        </div>
                    </a>
                </div>
                <div class="col-xs-6 col-sm-4 col-md-2">
                    <a href="<?php echo base_url(); ?>electricity" class="tool-link">
                        <div class="tool-icon">
                            <i class="fas fa-bolt"></i>
                            <h4>Electricity</h4>
                        </div>
                    </a>
                </div>
                <div class="col-xs-6 col-sm-4 col-md-2">
                    <a href="<?php echo base_url(); ?>insurance" class="tool-link">
                        <div class="tool-icon">
                            <i class="fas fa-tint"></i>
                            <h4>Insurance</h4>
                        </div>
                    </a>
                </div>
                <div class="col-xs-6 col-sm-4 col-md-2">
                    <a href="<?php echo base_url(); ?>gas" class="tool-link">
                        <div class="tool-icon">
                            <i class="fas fa-gas-pump"></i>
                            <h4>Gas Bill</h4>
                        </div>
                    </a>
                </div>
                <div class="col-xs-6 col-sm-4 col-md-2">
                    <a href="<?php echo base_url(); ?>pan-card" class="tool-link">
                        <div class="tool-icon">
                            <i class="fas fa-credit-card"></i>
                            <h4>PAN Card</h4>
                        </div>
                    </a>
                </div>
            </div>
        </div>

        <!-- Reports Tools Section -->
        <div class="tools-container reports-tools">
            <div class="tools-header">
                <i class="fas fa-chart-bar"></i> Reports & Management
            </div>
            <div class="row">
                <div class="col-xs-6 col-sm-4 col-md-2">
                    <a href="<?php echo base_url(); ?>recharge_report" class="tool-link">
                        <div class="tool-icon">
                            <i class="fas fa-history"></i>
                            <h4>Recharge History</h4>
                        </div>
                    </a>
                </div>
                <div class="col-xs-6 col-sm-4 col-md-2">
                    <a href="<?php echo base_url(); ?>recharge_history" class="tool-link">
                        <div class="tool-icon">
                            <i class="fas fa-file-invoice"></i>
                            <h4>Mini Statement</h4>
                        </div>
                    </a>
                </div>
                <div class="col-xs-6 col-sm-4 col-md-2">
                    <a href="<?php echo base_url(); ?>billing_summary" class="tool-link">
                        <div class="tool-icon">
                            <i class="fas fa-book"></i>
                            <h4>Ledger</h4>
                        </div>
                    </a>
                </div>
                <div class="col-xs-6 col-sm-4 col-md-2">
                    <a href="<?php echo base_url(); ?>add_fund" class="tool-link">
                        <div class="tool-icon">
                            <i class="fas fa-hand-holding-usd"></i>
                            <h4>Fund Request</h4>
                        </div>
                    </a>
                </div>
                <div class="col-xs-6 col-sm-4 col-md-2">
                    <a href="<?php echo base_url(); ?>add_fund" class="tool-link">
                        <div class="tool-icon">
                            <i class="fas fa-file-alt"></i>
                            <h4>Fund Reports</h4>
                        </div>
                    </a>
                </div>
                <div class="col-xs-6 col-sm-4 col-md-2">
                    <a href="<?php echo base_url(); ?>my_earning" class="tool-link">
                        <div class="tool-icon">
                            <i class="fas fa-money-bill-wave"></i>
                            <h4>My Earning</h4>
                        </div>
                    </a>
                </div>
                <div class="col-xs-6 col-sm-4 col-md-2">
                    <a href="<?php echo base_url(); ?>my_commission" class="tool-link">
                        <div class="tool-icon">
                            <i class="fas fa-percentage"></i>
                            <h4>My Commission</h4>
                        </div>
                    </a>
                </div>
                <div class="col-xs-6 col-sm-4 col-md-2">
                    <a href="<?php echo base_url(); ?>status_check" class="tool-link">
                        <div class="tool-icon">
                            <i class="fas fa-search"></i>
                            <h4>Search Recharge</h4>
                        </div>
                    </a>
                </div>
                <div class="col-xs-6 col-sm-4 col-md-2">
                    <a href="<?php echo base_url(); ?>search_plan" class="tool-link">
                        <div class="tool-icon">
                            <i class="fas fa-search-dollar"></i>
                            <h4>Search Plan</h4>
                        </div>
                    </a>
                </div>
                <div class="col-xs-6 col-sm-4 col-md-2">
                    <a href="<?php echo base_url(); ?>add_fund" class="tool-link">
                        <div class="tool-icon">
                            <i class="fas fa-plus-circle"></i>
                            <h4>Add Fund</h4>
                        </div>
                    </a>
                </div>
                
                <div class="col-xs-6 col-sm-4 col-md-2">
                    <a href="<?php echo base_url(); ?>set_ip" class="tool-link">
                        <div class="tool-icon">
                            <i class="fas fa-network-wired"></i>
                            <h4>Set IP</h4>
                        </div>
                    </a>
                </div>
                <div class="col-xs-6 col-sm-4 col-md-2">
                    <a href="<?php echo base_url(); ?>call_back_url" class="tool-link">
                        <div class="tool-icon">
                            <i class="fas fa-phone-alt"></i>
                            <h4>Set Callback</h4>
                        </div>
                    </a>
                </div>
            </div>
        </div>

        <!-- More Tools Section -->
        <div class="tools-container more-tools">
            <div class="tools-header">
                <i class="fas fa-ellipsis-h"></i> More
            </div>
            <div class="row">
                <div class="col-xs-6 col-sm-4 col-md-2">
                    <a href="<?php echo base_url(); ?>support_ticket" class="tool-link">
                        <div class="tool-icon">
                            <i class="fas fa-ticket-alt"></i>
                            <h4>Support Ticket</h4>
                        </div>
                    </a>
                </div>
                <div class="col-xs-6 col-sm-4 col-md-2">
                    <a href="<?php echo base_url(); ?>bank_details" class="tool-link">
                        <div class="tool-icon">
                            <i class="fas fa-university"></i>
                            <h4>Bank Details</h4>
                        </div>
                    </a>
                </div>
                <div class="col-xs-6 col-sm-4 col-md-2">
                    <a href="<?php echo base_url(); ?>my_profile" class="tool-link">
                        <div class="tool-icon">
                            <i class="fas fa-user-edit"></i>
                            <h4>Profile Edit</h4>
                        </div>
                    </a>
                </div>
                <div class="col-xs-6 col-sm-4 col-md-2">
                    <a href="<?php echo base_url(); ?>contact_details" class="tool-link">
                        <div class="tool-icon">
                            <i class="fas fa-address-book"></i>
                            <h4>Contact Details</h4>
                        </div>
                    </a>
                </div>
                <div class="col-xs-6 col-sm-4 col-md-2">
                    <a href="<?php echo base_url(); ?>change_pass" class="tool-link">
                        <div class="tool-icon">
                             <i class="fas fa-lock"></i>
                            <h4>Change Password</h4>
                        </div>
                    </a>
                </div>
                <div class="col-xs-6 col-sm-4 col-md-2">
                    <a href="<?php echo base_url(); ?>logout" class="tool-link">
                        <div class="tool-icon">
                            <i class="fas fa-sign-out-alt"></i>
                            <h4>Account Logout</h4>
                        </div>
                    </a>
                </div>
            </div>
        </div>

        <div class="table-responsive">
            <table class="summary-table">
                <thead>
                    <tr class="header-row">
                        <th>Metric</th>
                        <th>Value</th>
                        <th>Metric</th>
                        <th>Value</th>
                        <th>Metric</th>
                        <th>Value</th>
                        <th>Metric</th>
                        <th>Value</th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="data-row">
                        <!-- First Row -->
                        <td class="metric">Total Success</td>
                        <td class="value"><?php echo 0+$total_success;?></td>
                        
                        <td class="metric">Total Failure</td>
                        <td class="value"><?php echo 0+$total_failure;?></td>
                        
                        <td class="metric">Total Pending</td>
                        <td class="value"><?php echo 0+$total_pending;?></td>
                        
                        <td class="metric">Wallet Topup</td>
                        <td class="value"><?php echo 0+$total_purchase;?></td>
                    </tr>
                    <tr class="data-row">
                        <!-- Second Row -->
                        <td class="metric">Opening Balance</td>
                        <td class="value"><?php echo 0+$opening_balance;?></td>
                        
                        <td class="metric">Recharge Debit</td>
                        <td class="value">
                            <?php 
                                foreach ($get_recharge_credit_debit->result_array() as $value) {
                                    $refund = $value['sum(credit_amount)'];
                                    echo $recharge = $value['sum(debit_amount)']+0;
                                }
                            ?>
                        </td>
                        
                        <td class="metric">Refund Credit</td>
                        <td class="value"><?php echo 0+$refund;?></td>
                        
                        <td class="metric">Revert</td>
                        <td class="value">
                            <?php 
                                foreach ($billing_credit_debit->result_array() as $value) {
                                    echo $revert = $value['sum(debit_amount)']+0;
                                    $billing = $value['sum(credit_amount)'];
                                }
                            ?>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>

        <style>
            .table-responsive {
                width: 100%;
                overflow-x: auto;
                -webkit-overflow-scrolling: touch;
                border: 2px solid #e0e0e0;
                border-radius: 4px;
                margin: 10px 0;
            }
            
            .summary-table {
                width: 100%;
                border-collapse: collapse;
                min-width: 600px;
            }
            
            .header-row {
                height: 40px;
                background-color: #fce390;
            }
            
            .header-row th {
                border: 1px solid #000000;
                padding: 8px 12px;
                text-align: left;
                font-weight: 600;
                color: #000000;
            }
            
            .data-row {
                height: 36px;
            }
            
            .data-row:nth-child(odd) {
                background-color: #f5e8c1;
            }
            
            .data-row:nth-child(even) {
                background-color: #f5e8c1;
            }
            
            .metric, .value {
                padding: 8px 12px;
                border: 1px solid #000000;
                white-space: nowrap;
            }
            
            .metric {
                font-weight: 500;
                color: #333;
            }
            
            .value {
                font-weight: 400;
                color: #555;
            }
        </style>

        <br>
        <div class="panel panel-default">
            <div class="panel-heading">Todays Operator Report-</div>
            <div class="panel-body">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Company</th>
                            <th>Total Success</th>
                        </tr>
                    </thead>
                    <?php foreach ($operator_report->result_array() as $row) { ?>
                        <tr>
                            <td><?php echo $row['company_name'];?></td>
                            <td><?php echo $row['sum(amount)'];?></td>
                        </tr>
                    <?php } ?> 
                </table>
            </div>
        </div>
    </div>
    
   
   
    <div id="backToTop">
        <a href="body" data-animate-scroll="true"><i class="fa fa-angle-up"></i></a>
    </div>
    <!-- Back To Top Button End -->
    <?php include("app_js.php"); ?>
</body>
</html>