<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $title ?? 'My App'; ?></title>
    <style>
        /* Basic styling for the bottom navigation */
        body {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
            padding-bottom: 60px; /* Space for bottom nav */
        }
        
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background-color: #ffffff;
            display: flex;
            justify-content: space-around;
            padding: 10px 0;
            box-shadow: 0 -2px 5px rgba(0,0,0,0.1);
            z-index: 1000;
        }
        
        .nav-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-decoration: none;
            color: #333;
            font-size: 12px;
        }
        
        .nav-item i {
            font-size: 20px;
            margin-bottom: 4px;
        }
        
        .nav-item.active {
            color: #4285f4; /* Google blue color */
        }
    </style>
    <!-- Include Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
</head>
<body>
    <!-- Your main content here -->
    <div class="content">
        <?php $this->load->view($main_content); ?>
    </div>
    
    <!-- Bottom Navigation Bar -->
    <nav class="bottom-nav">
        <a href="<?php echo base_url('home'); ?>" class="nav-item <?php echo (uri_string() == 'home') ? 'active' : ''; ?>">
            <i class="fas fa-home"></i>
            <span>Home</span>
        </a>
        <a href="<?php echo base_url('search'); ?>" class="nav-item <?php echo (uri_string() == 'search') ? 'active' : ''; ?>">
            <i class="fas fa-search"></i>
            <span>Search</span>
        </a>
        <a href="<?php echo base_url('history'); ?>" class="nav-item <?php echo (uri_string() == 'history') ? 'active' : ''; ?>">
            <i class="fas fa-history"></i>
            <span>History</span>
        </a>
        <a href="<?php echo base_url('profile'); ?>" class="nav-item <?php echo (uri_string() == 'profile') ? 'active' : ''; ?>">
            <i class="fas fa-user"></i>
            <span>Profile</span>
        </a>
    </nav>
</body>
</html>